/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.graphics;

import ags.ui.graphics.DHGRImage;
import ags.ui.graphics.ImageBuffer;
import ags.ui.graphics.Palette48;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class DHGR2Image
implements ImageBuffer {
    Palette48 palette = new Palette48();
    DHGRImage i1 = new DHGRImage();
    DHGRImage i2 = new DHGRImage();
    public int mode = 0;

    public void readColorImage(String file) throws IOException {
        File f = new File(file);
        BufferedImage i = ImageIO.read(f);
        Image s = i.getScaledInstance(140, 192, 4);
        BufferedImage b = new BufferedImage(140, 192, 1);
        b.getGraphics().drawImage(s, 0, 0, null);
        for (int y = 0; y < 192; ++y) {
            for (int x = 0; x < 140; ++x) {
                int color = this.palette.findColor(b.getRGB(x, y));
                this.plotColor(x, y, color);
                b.setRGB(x, y, this.palette.getColorInt(color));
            }
        }
        ImageIO.write((RenderedImage)b, "bmp", new File("/apple2e/test_image.bmp"));
    }

    public byte[] getAppleImage(int i) {
        if (i == 0) {
            return this.i1.getAppleImage();
        }
        return this.i2.getAppleImage();
    }

    public byte[] getAppleImage() {
        return null;
    }

    public void plotColor(int x, int y, int color) {
        Integer[] colors = this.palette.getAppleColors(color);
        if (this.mode == 0 || this.mode == 1 && y % 2 == 0 || this.mode == 2 && x % 2 == y % 2) {
            this.i1.plotColor(x, y, colors[0]);
            this.i2.plotColor(x, y, colors[1]);
        } else {
            this.i1.plotColor(x, y, colors[1]);
            this.i2.plotColor(x, y, colors[0]);
        }
    }

    public void setTargetSize(int x, int y) {
    }
}

